﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using Nintendo.ServiceFramework.Hipc;
using nn;
using nn.sf;
using std;

namespace nn
{
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpan { }
}

namespace nn.account
{
    [CppRefPath(@"<nn/account/account_NintendoAccountTypes.h>")]
    [ExternalStruct(8, 8)]
    public struct NintendoAccountId { }

    [CppRefPath(@"<nn/account/account_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct Uid { }
}

namespace nn.ec.system
{
    [CppRefPath(@"<nn/ec/system/ec_DeviceAccountTypes.h>")]
    [ExternalStruct(32, 8)]
    public struct DeviceAccountInfo { }

    [CppRefPath(@"<nn/ec/system/ec_DeviceLinkTypes.h>")]
    [ExternalStruct(16, 1)]
    public struct DeviceLinkStatus { }

    [CppRefPath(@"<nn/ec/system/ec_VirtualAccountTypes.h>")]
    [ExternalStruct(4, 4)]
    public struct VirtualAccountId { }

    [CppRefPath(@"<nn/ec/system/ec_TicketSystemApi.h>")]
    [ExternalStruct(8, 1)]
    public struct TicketDownloadStatusForPrepurchasedContents { }
}

namespace nn.es
{
    [CppRefPath(@"<nn/es/es_Types.h>")]
    [ExternalStruct(16, 8)]
    public struct RightsIdIncludingKeyId { }
}

namespace nn.npns
{
    [CppRefPath(@"<nn/npns/npns_Types.h>")]
    [ExternalStruct(40, 4)]
    public struct NotificationToken { }
}

namespace nn.nim.detail
{
    public interface IShopServiceManager : IServiceObject
    {
        // ec_DeviceAuthenticationApi.h
        // 0 - 99
        [MethodId(0)]
        Result RequestDeviceAuthenticationToken(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);
        [MethodId(1)]
        Result RequestCachedDeviceAuthenticationToken(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, nn.TimeSpan remainingTime);

        // ec_DeviceAccountApi.h
        // 100 - 199
        [MethodId(100)]
        Result RequestRegisterDeviceAccount(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(101)]
        Result RequestUnregisterDeviceAccount(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(102)]
        Result RequestDeviceAccountStatus(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(103)]
        Result GetDeviceAccountInfo(Out<nn.ec.system.DeviceAccountInfo> outValue);

        [MethodId(104)]
        Result RequestDeviceRegistrationInfo(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync);

        [MethodId(105)]
        Result RequestTransferDeviceAccount(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(106)]
        Result RequestSyncRegistration(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(107)]
        Result IsOwnDeviceId(Out<bool> outValue, UInt64 deviceId);

        // ec_NotificationApi.h
        // 200 - 299
        [MethodId(200)]
        Result RequestRegisterNotificationToken(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.npns.NotificationToken notificationToken);

        // ec_DeviceLinkApi.h
        // 300 - 399
        [MethodId(300)]
        Result RequestUnlinkDevice(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.NintendoAccountId naUserId);

        [MethodId(301)]
        Result RequestUnlinkDeviceIntegrated(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid);

        [MethodId(302)]
        Result RequestLinkDevice(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid);

        [MethodId(303)]
        Result HasDeviceLink(Out<bool> outValue, nn.account.Uid uid);

        [MethodId(304)]
        Result RequestUnlinkDeviceAll(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync);

        [MethodId(305)]
        Result RequestCreateVirtualAccount(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.account.Uid uid);

        [MethodId(306)]
        Result RequestDeviceLinkStatus(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, nn.account.Uid uid);

        // ec_VirtualAccount[System]Api.h
        // 400 - 499
        [MethodId(400)]
        Result GetAccountByVirtualAccount(Out<nn.account.Uid> outValue, nn.ec.system.VirtualAccountId vaId);

        // ec_Ticket[System]Api.h
        // 500 - 599
        [MethodId(500)]
        Result RequestSyncTicket(Out<NativeHandle> outHandle, Out<IAsyncProgressResult> outAsync);

        [MethodId(501)]
        Result RequestDownloadTicket(Out<NativeHandle> outHandle, Out<IAsyncResult> outAsync, nn.es.RightsIdIncludingKeyId rightsId);

        [MethodId(502)]
        Result RequestDownloadTicketForPrepurchasedContents(Out<NativeHandle> outHandle, Out<IAsyncValue> outAsync, nn.es.RightsIdIncludingKeyId rightsId);
    }
}


