﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/nifm_Request.h>

#include <nn/nifm/detail/nifm_CommonDetail.h>
#include <nn/nifm/detail/nifm_RequestClient.h>

#include <new>


namespace nn
{
namespace nifm
{

Request::Request(const RequestParameters& parameters) NN_NOEXCEPT
    : m_Storage()
{
    NN_STATIC_ASSERT(sizeof(Storage) >= sizeof(detail::RequestClient));
    NN_STATIC_ASSERT(NN_ALIGNOF(Storage) % NN_ALIGNOF(detail::RequestClient) == 0);

    new(&m_Storage.storage) detail::RequestClient(parameters.requirementPreset, nn::os::EventClearMode_AutoClear);
}

Request::Request(const RequestParameters& parameters, nn::os::EventClearMode eventClearMode) NN_NOEXCEPT
    : m_Storage()
{
    new(&m_Storage.storage) detail::RequestClient(parameters.requirementPreset, eventClearMode);
}

Request::~Request() NN_NOEXCEPT
{
    reinterpret_cast<detail::RequestClient*>(&m_Storage)->~RequestClient();
}

void Request::Submit() NN_NOEXCEPT
{
    reinterpret_cast<detail::RequestClient*>(&m_Storage)->Submit();
}

void Request::SubmitAndWait() NN_NOEXCEPT
{
    reinterpret_cast<detail::RequestClient*>(&m_Storage)->SubmitAndWait();
}

void Request::Cancel() NN_NOEXCEPT
{
    reinterpret_cast<detail::RequestClient*>(&m_Storage)->Cancel();
}

RequestState Request::GetRequestState() NN_NOEXCEPT
{
    return reinterpret_cast<detail::RequestClient*>(&m_Storage)->GetRequestState();
}

nn::Result Request::GetResult() NN_NOEXCEPT
{
    return reinterpret_cast<detail::RequestClient*>(&m_Storage)->GetResult();
}

RequestHandle Request::GetHandle() NN_NOEXCEPT
{
    RequestHandle handle = { &m_Storage };

    return handle;
}

nn::os::SystemEvent& Request::GetSystemEvent() NN_NOEXCEPT
{
    return reinterpret_cast<detail::RequestClient*>(&m_Storage)->GetSystemEvent();
}

}
}
