﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nifm/detail/service/nifm_StaticServiceInterface.h>
#include <nn/nifm/detail/service/nifm_ServiceProvider.h>
#include <nn/nifm/detail/service/nifm_GeneralServiceInterface.h>
#include <nn/nifm/detail/util/nifm_SfUtility.h>

#include <nn/sf/sf_ObjectFactory.h>


namespace nn
{
namespace nifm
{
namespace detail
{

uint32_t StaticServiceInterface::g_ClientIdCounter = 0;

StaticServiceInterface::StaticServiceInterface(ServiceProvider* pServiceProvider, const Capability& capability, nn::sf::ExpHeapAllocator* pExpHeapAllocator) NN_NOEXCEPT
    : m_pServiceProvider(pServiceProvider),
      m_Capability(capability),
      m_pExpHeapAllocator(pExpHeapAllocator)
{
}

StaticServiceInterface::~StaticServiceInterface() NN_NOEXCEPT
{
}

nn::Result StaticServiceInterface::CreateGeneralServiceOld(nn::sf::Out<nn::sf::SharedPointer<IGeneralService>> outIGeneralService) NN_NOEXCEPT
{
    NN_RESULT_THROW(CreateGeneralService(outIGeneralService, 0));
}

nn::Result StaticServiceInterface::CreateGeneralService(nn::sf::Out<nn::sf::SharedPointer<IGeneralService>> outIGeneralService, nn::Bit64 processId) NN_NOEXCEPT
{
    auto pIGeneralService =
        nn::sf::ObjectFactory<nn::sf::ExpHeapAllocator::Policy>::CreateSharedEmplaced<IGeneralService, GeneralServiceInterface>(
            m_pExpHeapAllocator, m_pServiceProvider, m_Capability, m_pExpHeapAllocator, GenerateClientId(), processId
        );

    NN_RESULT_THROW_UNLESS(pIGeneralService != nullptr, ResultResourceNotFound());

    outIGeneralService.Set(pIGeneralService);

    NN_RESULT_SUCCESS;
}

ClientId StaticServiceInterface::GenerateClientId() NN_NOEXCEPT
{
    // まず重複せず、また仮に重複しても重大な問題にならない用途にしか用いない前提で重複チェックはしない
    do
    {
        ++g_ClientIdCounter;
    } while (g_ClientIdCounter == InvalidClientIdValue);

    ClientId clientId = { g_ClientIdCounter };

    return clientId;
}

}
}
}
