﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "./ngc_InputStream.h"

namespace nn { namespace ngc { namespace detail {

class  MemoryInputStream final : public InputStream
{
public:
    MemoryInputStream() NN_NOEXCEPT : m_pMisBuf(NULL), m_pMisSize(0) {}
    virtual ~MemoryInputStream() NN_NOEXCEPT override;
    template <class T, size_t N>
    explicit MemoryInputStream(const T (&buf)[N]) NN_NOEXCEPT
        : m_pMisBuf(reinterpret_cast<const uint8_t*>(&buf[0])), m_pMisSize(N * sizeof(T)) {}
    MemoryInputStream(const void* buf, size_t n) NN_NOEXCEPT;
    template <class T, size_t N>
    errno_t Init(const T (&buf)[N]) NN_NOEXCEPT
    {
        return this->Init(&buf[0], N * sizeof(T));
    }
    errno_t Init(const void* buf, size_t n) NN_NOEXCEPT;

private:
    virtual size_t FillBuffer_(void* p, size_t nbytes) NN_NOEXCEPT override;
    virtual bool Close_() NN_NOEXCEPT override
    {
        m_pMisBuf = NULL;
        m_pMisSize = 0;
        return true;
    }

private:
    const uint8_t* m_pMisBuf;
    size_t m_pMisSize;

    MemoryInputStream(const MemoryInputStream&) = delete;
    void operator=(const MemoryInputStream&) = delete;
};

}}} // nn::ngc::detail
