﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <cstring>
#include "ngc_String.h"

namespace nn {
namespace ngc {

    size_t wcslen( const char16_t* pString ) NN_NOEXCEPT
    {
        // TODO:g3d_ResUtility.cppから引用
        int len = 0;
        const char16_t* pCheckStr = pString;
        while ( NN_STATIC_CONDITION( 1 ) )
        {
            if ( *pCheckStr == 0x0 )
            {
                break;
            }
            ++pCheckStr;
            ++len;
        }
        return len;
    }

    int wcsncmp(
        const char16_t* pString1,
        const char16_t* pString2,
        size_t count
    ) NN_NOEXCEPT
    {
        return nn::util::Strncmp( pString1, pString2, static_cast< int >( count ) );
    }

    char* strncpy( char* pString1, const char* pString2, size_t count ) NN_NOEXCEPT
    {
        nn::util::Strlcpy( pString1, pString2, static_cast< int >( count ) ); // TODO: 返り値の処理はしたほうが良い
        return pString1;
    }

    void* memset( void* buf, int character, size_t count ) NN_NOEXCEPT
    {
        return std::memset( buf, character, count );
    }

}   // namespace ngc
}   // namespace nn
