﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/ngc/ngc_Result.h>
#include <nn/ngc/ngc_ProfanityFilterPatternList.h>

namespace nn { namespace ngc {namespace detail {

nn::Result GetFilterPatternData( void* pData, ProfanityFilterPatternList filterPattern, uint32_t size ) NN_NOEXCEPT;
nn::Result GetFilterPatternDataLength( uint32_t* pSize, ProfanityFilterPatternList filterPattern ) NN_NOEXCEPT;
nn::Result GetFilterVersionData( void* pData, uint32_t size ) NN_NOEXCEPT;
nn::Result GetFilterVersionDataLength( uint32_t* pSize ) NN_NOEXCEPT;

}}} // nn::ngc::detail
