﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nfc/nfc_Types.h>
#include <nn/nfc/nfc_Result.h>
#include <nn/nfc/nfc_PrivateResult.h>
#include <nn/nfc/nfc_NfpResult.internal.h>

namespace nn { namespace nfp { namespace server {

//! バックアップデータエントリの索引項目です。
struct BackupTocItem
{
    uint8_t   uidLength;                       //!< UID の長さ (1..10)
    nn::Bit8  uid[nn::nfc::UidLengthMax];      //!< UID
    nn::Bit8  flags;                           //!< 各種フラグ ([0]: 引っ越し予約ビット)
    nn::Bit16 entryRegisterDate;               //!< エントリ登録日
    nn::Bit8  reserved[14];                    //!< 予約
    nn::Bit32 hash;                            //!< 索引項目のハッシュ (CRC32)

    void Recalculate() NN_NOEXCEPT;
    void Clear() NN_NOEXCEPT;
    nn::Result Verify() const NN_NOEXCEPT;
};

}}}  // namespace nn::nfp::server
