﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstring>

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#define NN_NFP_DETAIL_REQUIRES_INITIALIZED(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFP ライブラリが初期化されていません。")
#define NN_NFP_DETAIL_REQUIRES_INITIALIZED_USER(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFP ライブラリが nn::nfp::Initialize() で初期化されていません。")
#define NN_NFP_DETAIL_REQUIRES_INITIALIZED_SYSTEM(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFP ライブラリが nn::nfp::InitializeSystem() で初期化されていません。")
#define NN_NFP_DETAIL_REQUIRES_INITIALIZED_DEBUG(sfSharedPointer) NN_SDK_REQUIRES(sfSharedPointer != nullptr, "NFP ライブラリが nn::nfp::InitializeDebug() で初期化されていません。")

#define NN_NFP_DETAIL_RETURN(x) return(nn::nfp::detail::CheckError(x))
#define NN_NFP_DETAIL_RESULT_DO(x) NN_RESULT_DO(nn::nfp::detail::CheckError(x))

namespace nn { namespace nfp { namespace detail {
nn::Result CheckError(const nn::Result& result);
}}}  // namespace nn::nfp::detail
