﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <nn/err.h>
#include <nn/nn_SdkLog.h>
#include <nn/os.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateResult.h>
#include <nn/nfc/detail/nfc_Util.h>
#include <nn/nfp/nfp_ErrorApi.h>

namespace nn { namespace nfp { namespace detail {

nn::Result CheckError(const nn::Result& result)
{
    if(result.IsSuccess())
    {
        return result;
    }
    NN_NFC_DETAIL_CHECK_ERROR(nn::nfp, result, nn::nfp::IsErrorVisible())

    return result;
}

}}}  // namespace nn::nfp::detail
