﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/nn_Common.h>
#include <nn/nfp/nfp_Result.h>
#include <nn/nfp/nfp_PrivateTypes.h>

namespace nn { namespace nfp { namespace detail {

const uint8_t StartParamVersionForAmiiboSettings = 0;

nn::os::Mutex& RefMutexForAmiiboSettings() NN_NOEXCEPT;
void GetBufferForAmiiboSettings(nn::nfp::ReturnValueForAmiiboSettings** pOutReturnValue, nn::nfp::StartParamForAmiiboSettings** pOutStartParam) NN_NOEXCEPT;
nn::Result StartAmiiboSettings(nn::nfp::ReturnValueForAmiiboSettings* pOutValue, const nn::nfp::StartParamForAmiiboSettings& param) NN_NOEXCEPT;

}}}  // namespace nn::nfp::detail
