﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

#include <nn/nfp/detail/nfp_Port.h>
#include <nn/nfp/detail/nfp_ISystem.h>    // for ISystem
#include "../detail/nfp_Util.h"
#ifdef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
#include <nn/nfp/server/nfp_CreateSystemManagerByDfc.h>
#endif

namespace nn { namespace nfp { namespace client {

namespace {

#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateSystemManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateSystemManagerByHipcTag> SystemAllocator;

nn::sf::HipcSimpleClientSessionManager g_SystemDomain;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class SystemAllocatorInitializer
{
public:

    SystemAllocatorInitializer() NN_NOEXCEPT
    {
        SystemAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_SystemAllocatorInitializer;

nn::sf::SharedPointer<nn::nfp::detail::ISystemManager> CreateSystemManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::nfp::detail::ISystemManager> pAccessor;
    auto result = g_SystemDomain.InitializeByName<nn::nfp::detail::ISystemManager, SystemAllocator::Policy>(&pAccessor, nn::nfp::detail::SystemPortName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_SystemDomain.SetSessionCount(nn::nfp::detail::SystemSessionCount));
    NN_SDK_ASSERT(pAccessor);
    return pAccessor;
}
#endif

nn::sf::SharedPointer<nn::nfp::detail::ISystem> g_RefSystemInterface = nullptr;

}

void CreateSystemInterface() NN_NOEXCEPT
{
#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    auto pAccessor = CreateSystemManagerByHipc();
#else
    auto pAccessor = nn::nfp::server::CreateSystemManagerByDfc();
#endif
    pAccessor->CreateSystemInterface(&g_RefSystemInterface);
    NN_SDK_ASSERT(g_RefSystemInterface);
    pAccessor = nullptr;
}

nn::sf::SharedPointer<nn::nfp::detail::ISystem>GetSystemInterface() NN_NOEXCEPT
{
    NN_NFP_DETAIL_REQUIRES_INITIALIZED_SYSTEM(g_RefSystemInterface);
    return g_RefSystemInterface;
}

void DestroySystemInterface() NN_NOEXCEPT
{
    g_RefSystemInterface = nullptr;
#ifndef NN_NFP_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    g_SystemDomain.Finalize();
#endif
}

bool IsCreatedSystemInterface() NN_NOEXCEPT
{
    return (g_RefSystemInterface != nullptr);
}

}}}
