﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <nn/nfc/server/util/nfc_UtilUtil.h>

namespace nn { namespace nfc { namespace server { namespace util {

namespace
{
}

bool IsEqualDeviceHandle(const nn::nfc::DeviceHandle& lhs, const nn::nfc::DeviceHandle& rhs) NN_NOEXCEPT
{
    return (lhs._id == rhs._id);
}

bool IsEqualTagId(const nn::nfc::TagId& lhs, const nn::nfc::TagId& rhs) NN_NOEXCEPT
{
    return (lhs.length == rhs.length && std::memcmp(lhs.uid, rhs.uid, lhs.length) == 0);
}

}}}}  // namespace nn::nfc::server::util
