﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include <nn/nfc/server/core/nfc_ScopedSession.h>
#include <nn/nfc/server/core/nfc_CoreManager.h>

namespace nn { namespace nfc { namespace server { namespace core {

ScopedSession::ScopedSession(nn::nfc::server::core::Service* service, nn::nfc::DeviceHandle handle) NN_NOEXCEPT : m_Handle(handle), m_Service(service), m_IsKept(false)
{
}

nn::Result ScopedSession::Keep() NN_NOEXCEPT
{
    NN_RESULT_DO(nn::nfc::server::core::Manager::GetInstance().KeepSession(m_Service, m_Handle));
    m_IsKept = true;
    NN_RESULT_SUCCESS;
}

void ScopedSession::Release() NN_NOEXCEPT
{
    if(!m_IsKept)
    {
        return;
    }

    nn::nfc::server::core::Manager::GetInstance().ReleaseSession(m_Service, m_Handle);
    m_IsKept = false;
}

ScopedSession::~ScopedSession() NN_NOEXCEPT
{
    Release();
}

}}}}  // namespace nn::nfc::server::core
