﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nfc/nfc_PrivateApi.h>
#include <nn/nfc/nfc_ErrorApi.h>
#include <nn/nn_Result.h>
#include <nn/applet/applet.h>
#include <nn/nfc/client/nfc_CommonInterface.h>
#include "client/nfc_McuVersionData.h"

namespace nn { namespace nfc {

void InitializeSystem() NN_NOEXCEPT
{
    NN_ABORT_UNLESS(!client::IsCreatedUserInterface());
    NN_ABORT_UNLESS(!client::IsCreatedSystemInterface());

    client::CreateSystemInterface();

    nn::sf::InArray<nn::xcd::McuVersionDataForNfc> requiredVersions(
        client::RequiredMcuVersionData,
        client::RequiredMcuVersionDataCount);

#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    nn::applet::AppletResourceUserId id = nn::applet::GetAppletResourceUserId();
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetSystemInterface()->Initialize(id, 0, requiredVersions));
#else
    nn::applet::AppletResourceUserId id = nn::applet::AppletResourceUserId::GetInvalidId();
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetSystemInterface()->Initialize(id, 1, requiredVersions));
#endif

    SetErrorVisible(true);
}

void FinalizeSystem() NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(client::GetSystemInterface()->Finalize());
    client::DestroySystemInterface();
}

void SetNfcEnabled(bool enable) NN_NOEXCEPT
{
    NN_ABORT_UNLESS_RESULT_SUCCESS(NN_NFC_CLIENT_GET_COMMON_INTERFACE_WITHOUT_USER(SetNfcEnabled, (enable)));
}

}}
