﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ExpHeapAllocator.h> // for nn::sf::ExpHeapStaticAllocator
#include <nn/nn_Abort.h>

#include <nn/nfc/detail/nfc_Port.h>
#include <nn/nfc/detail/nfc_IUser.h>    // for IUser
#include "../detail/nfc_Util.h"
#ifdef NN_NFC_BUILD_CONFIG_DIRECT_FUNCTION_CALL
#include <nn/nfc/server/nfc_CreateUserManagerByDfc.h>
#endif

namespace nn { namespace nfc { namespace client {

namespace {

#ifndef NN_NFC_BUILD_CONFIG_DIRECT_FUNCTION_CALL
// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateUserManagerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateUserManagerByHipcTag> UserAllocator;

nn::sf::HipcSimpleClientSessionManager g_UserDomain;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class UserAllocatorInitializer
{
public:

    UserAllocatorInitializer() NN_NOEXCEPT
    {
        UserAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_UserAllocatorInitializer;

nn::sf::SharedPointer<nn::nfc::detail::IUserManager> CreateUserManagerByHipc() NN_NOEXCEPT
{
    nn::sf::SharedPointer<nn::nfc::detail::IUserManager> pAccessor;
    auto result = g_UserDomain.InitializeByName<nn::nfc::detail::IUserManager, UserAllocator::Policy>(&pAccessor, nn::nfc::detail::UserPortName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    NN_ABORT_UNLESS_RESULT_SUCCESS(g_UserDomain.SetSessionCount(nn::nfc::detail::UserSessionCount));
    NN_SDK_ASSERT(pAccessor);
    return pAccessor;
}
#endif

nn::sf::SharedPointer<nn::nfc::detail::IUser> g_RefUserInterface = nullptr;

}

void CreateUserInterface() NN_NOEXCEPT
{
#ifndef NN_NFC_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    auto pAccessor = CreateUserManagerByHipc();
#else
    auto pAccessor = nn::nfc::server::CreateUserManagerByDfc();
#endif
    pAccessor->CreateUserInterface(&g_RefUserInterface);
    NN_SDK_ASSERT(g_RefUserInterface);
    pAccessor = nullptr;
}

nn::sf::SharedPointer<nn::nfc::detail::IUser>GetUserInterfaceForCommon() NN_NOEXCEPT
{
    NN_NFC_DETAIL_REQUIRES_INITIALIZED(g_RefUserInterface);
    return g_RefUserInterface;
}

nn::sf::SharedPointer<nn::nfc::detail::IUser>GetUserInterface() NN_NOEXCEPT
{
    NN_NFC_DETAIL_REQUIRES_INITIALIZED_USER(g_RefUserInterface);
    return g_RefUserInterface;
}

void DestroyUserInterface() NN_NOEXCEPT
{
    g_RefUserInterface = nullptr;
#ifndef NN_NFC_BUILD_CONFIG_DIRECT_FUNCTION_CALL
    g_UserDomain.Finalize();
#endif
}

bool IsCreatedUserInterface() NN_NOEXCEPT
{
    return (g_RefUserInterface != nullptr);
}

}}}
