﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "nfc_AmImpl.h"
#include <nn/nfc/server/core/nfc_CoreManager.h>

namespace nn { namespace nfc { namespace am { namespace server {

AmImpl::~AmImpl() NN_NOEXCEPT
{
    if(m_IsInitialized)
    {
        Finalize();
    }
}

nn::Result AmImpl::Initialize() NN_NOEXCEPT
{
    m_IsInitialized = true;
    NN_RESULT_SUCCESS;
}

nn::Result AmImpl::Finalize() NN_NOEXCEPT
{
    m_IsInitialized = false;
    NN_RESULT_SUCCESS;
}

nn::Result AmImpl::NotifyForegroundApplet(nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    nn::nfc::server::core::Manager::GetInstance().NotifyForegroundApplet(aruid);
    NN_RESULT_SUCCESS;
}

}}}}
