﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/msgpack/news_FileInputStream.h>

namespace nn { namespace news { namespace detail { namespace service { namespace msgpack {

FileInputStream::FileInputStream() NN_NOEXCEPT :
    m_IsOpened(false),
    m_IsSuspended(false),
    m_Path(nullptr),
    m_Offset(0),
    m_Buffer(nullptr),
    m_BufferSize(0)
{
}

FileInputStream::~FileInputStream() NN_NOEXCEPT
{
    Close();
}

void FileInputStream::SetBuffer(void* buffer, size_t size) NN_NOEXCEPT
{
    m_Buffer = buffer;
    m_BufferSize = size;
}

nn::Result FileInputStream::Open(const char* path) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(path);

    NN_SDK_ASSERT(!m_IsOpened);
    NN_SDK_ASSERT(!m_IsSuspended);

    NN_RESULT_DO(nn::fs::OpenFile(&m_Handle, path, nn::fs::OpenMode_Read));

    m_IsOpened = true;
    m_IsSuspended = false;
    m_Offset = 0;
    m_Path = path;

    NN_RESULT_SUCCESS;
}

void FileInputStream::Close() NN_NOEXCEPT
{
    if (m_IsOpened)
    {
        nn::fs::CloseFile(m_Handle);
        m_IsOpened = false;
    }

    m_IsSuspended = false;
}

size_t FileInputStream::FillBuffer_(void* p, size_t nbytes) NN_NOEXCEPT
{
    size_t read = 0;
    nn::Result result = nn::fs::ReadFile(&read, m_Handle, m_Offset, p, nbytes);

    if (result.IsSuccess())
    {
        m_Offset += read;
    }
    else
    {
        SetError(EIO);
        return 0;
    }

    return read;
}

bool FileInputStream::Close_() NN_NOEXCEPT
{
    Close();
    return true;
}

void* FileInputStream::GetWorkBuffer_(size_t* nbytes) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(m_Buffer);

    if (nbytes)
    {
        *nbytes = m_BufferSize;
    }

    return m_Buffer;
}

size_t FileInputStream::Skip_(size_t nbytes) NN_NOEXCEPT
{
    m_Offset += nbytes;
    return nbytes;
}

}}}}}
