﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/news/detail/service/core/news_StringVerifier.h>

namespace nn { namespace news { namespace detail { namespace service { namespace core {

bool StringVerifier::VerifyTopicId(const char* topicId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(topicId);

    const char* p = topicId;

    while (*p)
    {
        char c = *p;

        // [0-9a-zA-Z_]
        if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c == '_'))
        {
            p++;
        }
        else
        {
            return false;
        }
        if (static_cast<size_t>(p - topicId) > TopicIdLengthMax)
        {
            return false;
        }
    }

    return (p != topicId);
}

bool StringVerifier::VerifyPassphrase(const char* passphrase) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(passphrase);

    const char* p = passphrase;

    while (*p)
    {
        char c = *p;

        // [0-9a-zA-Z]
        if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z'))
        {
            p++;
        }
        else
        {
            return false;
        }
        if (static_cast<size_t>(p - passphrase) > PassphraseLengthMax)
        {
            return false;
        }
    }

    return (p != passphrase);
}

bool StringVerifier::VerifyETag(const char* eTag) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(eTag);

    const char* p = eTag;

    while (*p)
    {
        char c = *p;

        // 制御コードを除く ASCII
        if (c >= ' ' && c <= 0x7E)
        {
            p++;
        }
        else
        {
            return false;
        }
    }

    return (p != eTag);
}

bool StringVerifier::VerifyDataName(const char* name) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(name);

    const char* p = name;

    while (*p)
    {
        char c = *p;

        // [0-9a-zA-Z_.]
        if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') || (c == '_') || (c == '.'))
        {
            p++;
        }
        else
        {
            return false;
        }
        if (static_cast<size_t>(p - name) > DataNameLengthMax)
        {
            return false;
        }
    }

    return (p != name);
}

bool StringVerifier::VerifyDatabaseStringValue(const char* value) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(value);

    const char* p = value;

    while (*p)
    {
        char c = *p;

        // [0-9a-zA-Z -:/]
        if ((c >= '0' && c <= '9') || (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z') ||
            (c == ' ') || (c == '-') || (c == ':') || (c == '/'))
        {
            p++;
        }
        else
        {
            return false;
        }
        if (static_cast<size_t>(p - value) > StringValueLengthMax)
        {
            return false;
        }
    }

    return true;
}

}}}}}
