﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mmnv/server/mmnv_RequestHipcServer.h>

#include <nn/nn_Common.h>
#include <nn/sf/sf_HipcServer.h>
#include "..\mmnv_CreateRequest.h"
#include "..\mmnv_ServiceName.h"
#include <type_traits>
#include <new>
#include <nn/nn_SdkAssert.h>

namespace nn     {
namespace mmnv   {
namespace server {

namespace {

class MyServerManager : public nn::sf::HipcSimpleAllInOneServerManager<40, 1>
{
    virtual nn::Result OnNeedsToAccept(int portIndex, PortForAllInOne* pPort) NN_NOEXCEPT NN_OVERRIDE final
    {
        NN_UNUSED(portIndex);
        return this->AcceptImpl(pPort, CreateRequestByDfc());
    }
};

std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_MyServerManagerStorage;
MyServerManager* g_pMyServerManager;

}


void InitializeRequestServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(!g_pMyServerManager);

    g_pMyServerManager = new (&g_MyServerManagerStorage) MyServerManager;

    auto sessionCountMax = 40;
    auto result = g_pMyServerManager->InitializePort(0, sessionCountMax, MmnvRequestServiceName);
    NN_ABORT_UNLESS(result.IsSuccess());

    g_pMyServerManager->Start();
}

void LoopRequestServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pMyServerManager);

    g_pMyServerManager->LoopAuto();
}

}}}
