﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/mii/detail/service/mii_ImageServiceProviderClient.h>
#include <nn/mii/detail/service/mii_ServiceNames.h>
#include <nn/mii/detail/service/mii_IImageDatabaseService.sfdl.h>
#include <nn/mii/mii_ApiServer.h>

#include <nn/sf/sf_ShimLibraryUtility.h>

namespace nn
{
namespace mii
{
namespace detail
{

#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
namespace
{
    nn::sf::SimpleAllInOneHipcClientManager<1> g_Manager = NN_SF_SIMPLE_ALL_IN_ONE_HIPC_CLIENT_MANAGER_INITIALIZER;
    nn::sf::ShimLibraryObjectHolder<detail::IImageDatabaseService> g_Holder = NN_SF_SHIM_LIBRARY_OBJECT_HOLDER_INITIALIZER;
}
#endif

nn::Result ImageServiceProviderClient::GetImageDatabaseServiceSharedPointer(
    nn::sf::SharedPointer<IImageDatabaseService>* ppDatabaseService) NN_NOEXCEPT
{
#if NN_DETAIL_MII_CONFIG_SERVER_MODEL == NN_DETAIL_MII_CONFIG_SERVER_MODEL_THREAD
    NN_RESULT_DO(RegisterServer());
#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(StartServer());
#endif
#endif

#if NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_DFC
    ServiceProvider* pServiceProvider = GetServiceProviderPointer();
    NN_SDK_ASSERT_NOT_NULL(pServiceProvider);
    *ppDatabaseService = pServiceProvider->m_HipcServerManager.GetImageDatabaseStaticService().GetShared();
    NN_RESULT_SUCCESS;
#elif NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL == NN_DETAIL_MII_CONFIG_SERVICE_FRAMEWORK_MODEL_HIPC
    NN_RESULT_DO(g_Manager.InitializeShimLibraryHolder(&g_Holder, detail::ImageDatabaseServiceName));
    *ppDatabaseService = g_Holder.GetObject();
    NN_RESULT_SUCCESS;
#endif
}

}
}
}
