﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_Abort.h>
#include <nn/sf/sf_HipcClient.h>
#include <nn/sf/sf_ProxyObjectAllocator.h>
#include <nn/lm/detail/lm_ILogService.h>

namespace nn { namespace lm {

extern const char* LogServiceName;

sf::SharedPointer<ILogService> CreateLogServiceByHipc() NN_NOEXCEPT
{
    // ILogService と ILogger を1つずつ確保できるアロケータを用意
    NN_FUNCTION_LOCAL_STATIC(nn::sf::ProxyObjectAllocator<2>, s_Allocator, = NN_SF_PROXY_OBJECT_ALLOCATOR_INITIALIZER);
    s_Allocator.Initialize(); // Finalize()しないのでInitialize()が複数回呼ばれても問題ない

    sf::SharedPointer<ILogService> pointer;
    auto result = sf::CreateHipcProxyByName<ILogService>(&pointer, s_Allocator.GetMemoryResource(), LogServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);

    return pointer;
}

}} // nn::lm
