﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_ConditionVariable.h>

#include "lm_CustomSinkBuffer.h"

namespace nn { namespace lm { namespace impl {


class LogGetterImpl
{
    NN_DISALLOW_COPY(LogGetterImpl);
    NN_DISALLOW_MOVE(LogGetterImpl);

public:
    static CustomSinkBuffer& GetBuffer() NN_NOEXCEPT;
    static int64_t GetLog(char* buffer, size_t bufferSize, uint32_t* dropCount) NN_NOEXCEPT;
    static void IncreaseLogPacketDropCount() NN_NOEXCEPT { m_LogPacketDropCount++; }

private:
    LogGetterImpl() {};
    static bool FlushFunc(const uint8_t* buffer, size_t bufferSize) NN_NOEXCEPT;

    static const uint8_t *m_pMessage;
    static size_t m_BufferSize;
    static size_t m_LogPacketDropCount;
};
}}} // nn::lm::impl
