﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkLog.h>
#include <nn/lm/lm_LogDestinationType.h>
#include "lm_LoggerImpl.h"
#include "lm_LogBuffer.h"
#include "lm_LogGetter.h"
#include "lm_LogGetterImpl.h"

namespace nn { namespace lm { namespace impl {

extern bool g_IsLoggingToCustomSink;

Result LogGetter::StartLogging() NN_NOEXCEPT
{
    g_IsLoggingToCustomSink = true;
    return ResultSuccess();
}

Result LogGetter::StopLogging() NN_NOEXCEPT
{
    g_IsLoggingToCustomSink = false;
    return ResultSuccess();
}

Result LogGetter::GetLog(sf::OutBuffer message, sf::Out<int64_t> pOutSize, sf::Out<uint32_t> pOutDropCount) NN_NOEXCEPT
{
    if (LogGetterImpl::GetBuffer().TryFlush())
    {
        auto writeSize = LogGetterImpl::GetLog(message.GetPointerUnsafe(), message.GetSize(), pOutDropCount.GetPointer());
        *pOutSize = writeSize;
        return ResultSuccess();
    }
    *pOutSize = 0;
    return ResultSuccess();
}

}}} // nn::lm::impl
