﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>

#include <nn/sf/sf_HipcClientProxyByName.h>   // for nn::sf::CreateHipcProxyByName
#include <nn/sf/sf_ExpHeapAllocator.h>        // for nn::sf::ExpHeapStaticAllocator

#include "detail/lbl_ServiceType.h"           // for SfsmplCalculatorServiceName
#include <nn/lbl/detail/lbl_ILblController.h> // for ILblController

#include "lbl_CreateLblControllerByHipc.h"

namespace nn { namespace lbl {

namespace {

// 拡張ヒープを使用したアロケータを、HIPC プロキシ用に準備
struct CreateLblControllerByHipcTag;
typedef nn::sf::ExpHeapStaticAllocator<1024 * 16, CreateLblControllerByHipcTag> MyAllocator;

// MyAllocator を静的コンストラクタで初期化するためのヘルパー
class MyAllocatorInitializer
{
public:

    MyAllocatorInitializer() NN_NOEXCEPT
    {
        MyAllocator::Initialize(nn::lmem::CreationOption_NoOption);
    }

} g_MyAllocatorInitializer;

}

nn::sf::SharedPointer<nn::lbl::detail::ILblController> CreateLblControllerByHipc() NN_NOEXCEPT
{
    // LblServiceName のサービス名で示される HIPC サービスオブジェクトを、
    // ILblController としてプロキシクライアントを作成して返す。
    // アロケーションポリシーとして MyAllocator::Policy を渡している。
    nn::sf::SharedPointer<nn::lbl::detail::ILblController> ret;
    auto result = nn::sf::CreateHipcProxyByName<nn::lbl::detail::ILblController, MyAllocator::Policy>(&ret, nn::lbl::detail::LblServiceName);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
    return ret;
}

}}
