﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/idle/idle_SystemTypes.h>

namespace nn { namespace idle { namespace server {

    class PolicyParamHolder
    {
    public:
        PolicyParamHolder() NN_NOEXCEPT;

        const nn::idle::server::PolicyParam& Get() const NN_NOEXCEPT
        {
            return m_PolicyParam;
        }

        void Initialize() NN_NOEXCEPT;
        void LoadSystemSettings() NN_NOEXCEPT;
        void LoadFirmwareDebugSettings() NN_NOEXCEPT;
        void UpdateHandlingContext(const nn::idle::HandlingContext& handlingContext) NN_NOEXCEPT;

    private:
        nn::idle::server::PolicyParam m_PolicyParam;
    };

}}} // namespace nn::idle::server

