﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/settings/system/settings_Sleep.h>
#include <nn/settings/system/settings_Tv.h>
#include <nn/idle/idle_SystemTypes.h>

namespace nn { namespace idle { namespace server {

    struct PolicyParam
    {
        // 本体設定から
        nn::settings::system::HandheldSleepPlan     handheldSleepPlan;
        nn::settings::system::ConsoleSleepPlan      consoleSleepPlan;
        bool                                        isAutoSleepInMediaPlaybackEnabled;
        bool                                        isTvDimmingEnabled;

        // am/omm から渡される実行コンテキスト
        HandlingContext                             handlingContext;

        // fwdbg で注入される上書き設定
        bool                                        isAutoSleepDisabledForDebug;
        int                                         overrideAutoSleepTimeForDebugInSeconds;
    };

}}} // namespace nn::idle::server

