﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/idle/detail/idle_Log.h>

#include "idle_HandlerImpl.h"
#include "idle_HandlerImplSleeper.h"
#include "idle_HandlerImplDimmer.h"
#include "idle_IHandler.h"

namespace nn { namespace idle { namespace server {

namespace {
    nn::idle::server::HandlerImplDimmer g_HandlerImplDimmer;
    nn::idle::server::HandlerImplSleeper g_HandlerImplSleeper;

    nn::idle::server::IHandler* const HandlerImplList[] = {
        &g_HandlerImplDimmer,
        &g_HandlerImplSleeper,
    };
}

// 純粋仮想デストラクタの定義
IHandler::~IHandler() NN_NOEXCEPT
{
}

void HandlerImpl::Initialize() NN_NOEXCEPT
{
    for ( auto pHandler : HandlerImplList )
    {
        pHandler->InitializeBase();
        pHandler->Initialize();
    }
}

void HandlerImpl::Enable() NN_NOEXCEPT
{
    for (auto pHandler : HandlerImplList)
    {
        if ( !pHandler->IsEnabled() )
        {
            pHandler->Enable();
        }
    }
}

void HandlerImpl::Disable() NN_NOEXCEPT
{
    for (auto pHandler : HandlerImplList)
    {
        if ( pHandler->IsEnabled() )
        {
            pHandler->NotifyActivity(); // 発動状態で disable する場合は一旦解除してからにする
            pHandler->Disable();
        }
    }
}

void HandlerImpl::UpdatePolicy(const PolicyParam& policyParam) NN_NOEXCEPT
{
    for (auto pHandler : HandlerImplList)
    {
        pHandler->UpdatePolicy(policyParam);
    }
}

void HandlerImpl::NotifyActivity() NN_NOEXCEPT
{
    for ( auto pHandler : HandlerImplList )
    {
        pHandler->NotifyActivity();
    }
}

void HandlerImpl::NotifyInactivity(const nn::TimeSpan& elapsedIdleTime) NN_NOEXCEPT
{
    for (auto pHandler : HandlerImplList)
    {
        pHandler->NotifyInactivity(elapsedIdleTime);
    }
}

nn::os::SystemEventType* HandlerImpl::GetAutoPowerDownEvent() NN_NOEXCEPT
{
    return g_HandlerImplSleeper.GetAutoPowerDownEvent();
}

bool HandlerImpl::IsAutoPowerDownOn() NN_NOEXCEPT
{
    return g_HandlerImplSleeper.IsTriggered();
}

bool HandlerImpl::IsDimmingOn() NN_NOEXCEPT
{
    return g_HandlerImplDimmer.IsTriggered();
}

}}} // namespace nn::idle::server

