﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.detail
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/nn_DeviceCode.h>")]
    public struct DeviceCodeType
    {
    }
}

namespace nn.i2c
{
    [CppRefPath("<nn/i2c/i2c_ServiceType.h>")]
    [ExternalStruct(1, 1)]
    public struct I2cCommand
    {
    }

    // 実操作を担当する I2C のセッションオブジェクト。
    // セッションの取得は Manager で行う。
    [CppRefPath("<nn/i2c/i2c_ISession.sfdl.h>")]
    interface ISession : IServiceObject
    {
        [MethodId(0)]
        Result SendOld(nn.sf.InBuffer inData, int32_t inOption );

        [MethodId(1)]
        Result ReceiveOld(nn.sf.OutBuffer outData, int32_t inOption );

        [MethodId(2)]
        Result ExecuteCommandListOld(nn.sf.OutBuffer receiveBuffer, nn.sf.InArray<I2cCommand> commandList);

        [MethodId(10)]
        Result Send([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.InBuffer inData, int32_t inOption );

        [MethodId(11)]
        Result Receive([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer outData, int32_t inOption );

        [MethodId(12)]
        Result ExecuteCommandList([Nintendo.ServiceFramework.Hipc.AutoSelectBuffer] nn.sf.OutBuffer receiveBuffer, nn.sf.InArray<I2cCommand> commandList);

        // [Gen2]
        [MethodId(13)]
        Result SetRetryPolicy(int32_t maxRetryCount, int32_t retryIntervalMicroSeconds);
    }

    // I2c セッションを返すマネージャークラス
    [CppRefPath("<nn/i2c/i2c_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        // [Gen1] TODO: Deprecate
        [MethodId(0)]
        Result OpenSessionForDev(Out<ISession> outSession, int32_t busIdx, nn.Bit16 slaveAddress, int32_t addressingMode, int32_t speedMode );

        // [Gen1] TODO: Deprecate
        [MethodId(1)]
        Result OpenSession(Out<ISession> outSession, int32_t device);

        // [Gen1] NOT SUPPORTED
        // [Gen2] NOT SUPPORTED
        [MethodId(2)]
        Result HasDevice(Out<bool> hasDevice, int32_t device);

        // [Gen1] NOT SUPPORTED
        // [Gen2] NOT SUPPORTED
        [MethodId(3)]
        Result HasDeviceForDev(Out<bool> hasDevice, int32_t busIdx, nn.Bit16 slaveAddress, int32_t addressingMode, int32_t speedMode );

        // [Gen2]
        [MethodId(4)]
        Result OpenSession2(Out<ISession> outSession, nn.detail.DeviceCodeType name);
    }
}
