﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/http/stream/http_ClientCertificate.h>

#include <curl/curl.h>

#include <nn/nn_Result.h>
#include <nn/nn_SdkAssert.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/ssl/ssl_Context.h>

namespace nn { namespace http { namespace stream {

#if defined(NN_HTTP_HFIO_CERT_ENABLE)
extern Result LoadClientCerificate(
    char** pOutCert, size_t* pOutCertSize,
    char** pOutPassword, size_t* pOutPasswordSize,
    const CertIoBuffer& buffer) NN_NOEXCEPT;
#endif

Result SslCtxHandlerWithClientCert(CURL* curlHandle, ssl::Context& context, void* userData) NN_NOEXCEPT
{
    NN_UNUSED(curlHandle);
    NN_SDK_ASSERT(userData != nullptr);
    NN_SDK_ASSERT(userData);

#if defined(NN_HTTP_HFIO_CERT_ENABLE)
    auto& ioBuffer = *reinterpret_cast<CertIoBuffer*>(userData);
    char* cert;
    size_t certSize;
    char* password;
    size_t passwordSize;
    NN_RESULT_DO(LoadClientCerificate(&cert, &certSize, &password, &passwordSize, ioBuffer));

    ssl::CertStoreId clientCertStoreId;
    NN_RESULT_DO(context.ImportClientPki(&clientCertStoreId, cert, password, static_cast<uint32_t>(certSize), static_cast<uint32_t>(passwordSize)));

#else // NN_HTTP_HFIO_CERT_ENABLE
    ssl::CertStoreId clientCertStoreId;
    NN_RESULT_DO(context.RegisterInternalPki(&clientCertStoreId, ssl::Context::InternalPki_DeviceClientCertDefault));

#endif // NN_HTTP_HFIO_CERT_ENABLE
    NN_RESULT_SUCCESS;
}

}}} // ~namespace nn::http::stream
