﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/http/json/http_JsonPath.h>

#include <limits>

#include <nn/nn_Abort.h>
#include <nn/util/util_FormatString.h>

namespace nn { namespace http { namespace json {

const Node Node::Root = {Kind::Root, 0};
const Node Node::Object = {Kind::Object, 0};
const Node Node::Array = {Kind::Array, 0};
const Node Node::Key = {Kind::Key, 0};

int16_t Node::Print(char* str, size_t bufferSize, const char* key) const NN_NOEXCEPT
{
    switch (kind)
    {
    case Kind::Root:
        return static_cast<int16_t>(nn::util::SNPrintf(str, bufferSize, "$"));
    case Kind::Object:
        return static_cast<int16_t>(nn::util::SNPrintf(str, bufferSize, ""));
    case Kind::Array:
        return static_cast<int16_t>(nn::util::SNPrintf(str, bufferSize, "[%u]", arrayElementCount));
    case Kind::Key:
        NN_SDK_REQUIRES(key != nullptr);
        {
            auto l = nn::util::SNPrintf(str, bufferSize, ".%s", key);
            NN_ABORT_UNLESS(l <= std::numeric_limits<int16_t>::max(),
                "[nn::http] -----------------------------------------------\n"
                "  ABORT: Unacceptable key length: \".%s\"(length=%d)\n", key, l);
            return static_cast<int16_t>(l);
        }
    default:
        NN_UNEXPECTED_DEFAULT;
    }
}

}}} // ~namespace nn::http::json
