﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_TimeSpan.h>
#include <nn/nn_Result.h>
#include "nn/http/http_LibraryMain.h"
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#include <curl/curl.h>

#define NN_HTTP_RESULT_THROW_IF_FAILURE(r) \
    if (r.IsFailure()) { \
        NN_RESULT_THROW(r); \
    }

#if defined(NN_SDK_BUILD_DEBUG)
#   define NN_HTTP_TRACE(...)           NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 0, ##__VA_ARGS__)
#   define NN_HTTP_INFO(...)            NN_DETAIL_STRUCTURED_SDK_LOG(http, Info,  0, ##__VA_ARGS__)
#else
#   define NN_HTTP_TRACE(...)           (void)0
#   define NN_HTTP_INFO(...)            (void)0
#endif
#define NN_HTTP_ERROR(...)              NN_DETAIL_STRUCTURED_SDK_LOG(http, Error, 0, ##__VA_ARGS__)
#define NN_HTTP_WARN(...)               NN_DETAIL_STRUCTURED_SDK_LOG(http, Warn,  0, ##__VA_ARGS__)
#define NN_HTTP_TRACE_ALWAYS(...)       NN_DETAIL_STRUCTURED_SDK_LOG(http, Trace, 0, ##__VA_ARGS__)

namespace nn
{
namespace http
{
    Result CurlEasyInit(CURL *& pCurlHandle);
    void CurlEasyCleanup(CURL* pCurlHandle);
    Result ConvertCurlCodeToResult(CURLcode code);
    Result ConvertCurlMultiCodeToResult(CURLMcode mcode);

    void SetAllocateFunctions(AllocateFunction allocfun, FreeFunction freefun, ReAllocateFunction reallocfun);
    void* AllocateMemory(size_t size);
    void FreeMemory(void* p);
    void* ReAllocateMemory(void* p, size_t size);
    void* AllocateZeroInitializedArray(size_t number, size_t size);
    char *DuplicateString(const char *s);
}
}
