﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <memory>

#include <nn/nn_Result.h>

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>

#include <nn/htclow.h>
#include <nn/htclow/detail/htclow_InternalTypes.h>

#include "../driver/htclow_DriverManager.h"

#include "htclow_ChannelResourceMap.h"

namespace nn { namespace htclow { namespace server { namespace mux {

    class Mux
    {
        NN_DISALLOW_COPY(Mux);
        NN_DISALLOW_MOVE(Mux);

    public:
        Mux() NN_NOEXCEPT;

        // API スレッド向けインターフェース
        Result Open(detail::ChannelInternalType channel) NN_NOEXCEPT;
        void Close(detail::ChannelInternalType channel) NN_NOEXCEPT;

        Result Connect(detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result Shutdown(detail::ChannelInternalType channel) NN_NOEXCEPT;

        Result Receive(int* pOutSize, void* pOutBuffer, int bufferSize, detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result Send(int* pOutSize, const void* buffer, int bufferSize, detail::ChannelInternalType channel) NN_NOEXCEPT;

        Result GetClosedEventHandle(nn::os::NativeHandle* pOutHandle, detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result GetEstablishedEventHandle(nn::os::NativeHandle* pOutHandle, detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result GetReceiveReadyEventHandle(nn::os::NativeHandle* pOutHandle, detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result GetSendReadyEventHandle(nn::os::NativeHandle* pOutHandle, detail::ChannelInternalType channel) NN_NOEXCEPT;
        Result GetSendCompleteEventHandle(nn::os::NativeHandle* pOutHandle, detail::ChannelInternalType channel) NN_NOEXCEPT;

        void CancelAllChannel() NN_NOEXCEPT;
        void SetRetransmitEnabled(bool enabled) NN_NOEXCEPT;

        // Worker 向けインターフェース
        void SetCancelEvent(nn::os::Event* pEvent) NN_NOEXCEPT;
        void RemoveAckPacket(detail::ChannelInternalType channel, int64_t sequenceId) NN_NOEXCEPT;

        Result QuerySendPacket(SendPacket** ppOutSendPacket) NN_NOEXCEPT;
        Result ProcessReceivePacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;

    private:
        Result ProcessReceiveDataPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;
        Result ProcessReceiveDataAckPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;
        Result ProcessReceiveSynAckPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;
        Result ProcessReceiveFinPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;
        Result ProcessReceiveFinAckPacket(std::unique_ptr<ReceivePacket> packet) NN_NOEXCEPT;

        ChannelResourceMap m_ChannelResources;

        // ChannelResource を操作するときに lock する global mutex
        nn::os::SdkMutex m_ChannelResourceMutex;

        // GetSendReadyEventHandle() でハンドルを返すイベント
        nn::os::SystemEvent m_ApiSendReadyEvent;

        // 送信パケットが追加されたことを示すイベント
        nn::os::Event m_AddSendPacketEvent;

        // Worker から登録されるキャンセルイベント
        nn::os::Event* m_pCancelEvent;
    };

}}}}
