﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#include <nn/htclow.h>
#include <nn/htclow/htclow_ResultPrivate.h>

#include <nn/util/util_TypedStorage.h>

#include "htclow_ChannelResourceMap.h"

namespace nn { namespace htclow { namespace server { namespace mux {

    bool ChannelResourceMap::Exists(detail::ChannelInternalType channel) const NN_NOEXCEPT
    {
        return m_Map.find(channel) != m_Map.end();
    }

    Result ChannelResourceMap::AddChannel(detail::ChannelInternalType channel) NN_NOEXCEPT
    {
        int index;
        for (index = 0; index < MaxChannelCount; index++)
        {
            if (!m_StorageValid[index])
            {
                break;
            }
        }

        if (index == MaxChannelCount)
        {
            return ResultOutOfChannel();
        }

        auto pChannelResource = &nn::util::Get(m_Storages[index]);
        new (pChannelResource) ChannelResource(m_RetransmitEnabled);

        m_Map.insert(std::make_pair(channel, index));

        m_StorageValid[index] = true;

        NN_RESULT_SUCCESS;
    }

    Result ChannelResourceMap::RemoveChannel(detail::ChannelInternalType channel) NN_NOEXCEPT
    {
        auto index = m_Map.at(channel);
        auto pChannelResource = &nn::util::Get(m_Storages[index]);

        NN_SDK_ASSERT(0 <= index && index < MaxChannelCount);

        m_StorageValid[index] = false;

        m_Map.erase(channel);

        pChannelResource->~ChannelResource();

        NN_RESULT_SUCCESS;
    }

    ChannelResource& ChannelResourceMap::GetChannelResource(int index) NN_NOEXCEPT
    {
        return nn::util::Get(m_Storages[index]);
    }

    ChannelResource& ChannelResourceMap::GetChannelResource(detail::ChannelInternalType channel) NN_NOEXCEPT
    {
        return GetChannelResource(m_Map.at(channel));
    }

}}}}
