﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <limits>

#include <nn/result/result_HandlingUtility.h>
#include <nn/sf/sf_NativeHandle.h>

#include <nn/htclow/htclow_ResultPrivate.h>

#include "htclow_Impl.h"
#include "htclow_DebugServiceObject.h"

namespace nn {
namespace htclow {
namespace server {

nn::Result DebugServiceObject::SendFromTest(const nn::sf::InBuffer& buffer) NN_NOEXCEPT
{
#if defined(NNT_DETAIL_HTCLOW_ENABLE_DEBUG_DRIVER)
    NN_STATIC_ASSERT(sizeof(size_t) >= sizeof(int));
    if (buffer.GetSize() > static_cast<size_t>(std::numeric_limits<int>::max()))
    {
        return ResultDebugDriverError();
    }
    const int size = static_cast<int>(buffer.GetSize());

    return HtclowImpl::GetInstance()->GetDriverManager()->GetDebugDriver()->WriteToReceiveBuffer(buffer.GetPointerUnsafe(), size);
#else
    return ResultUnsupportedDriverType();
#endif
}

nn::Result DebugServiceObject::ReceiveFromTest(const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
{
#if defined(NNT_DETAIL_HTCLOW_ENABLE_DEBUG_DRIVER)
    NN_STATIC_ASSERT(sizeof(size_t) >= sizeof(int));
    if (outBuffer.GetSize() > static_cast<size_t>(std::numeric_limits<int>::max()))
    {
        return ResultDebugDriverError();
    }
    const int size = static_cast<int>(outBuffer.GetSize());

    return HtclowImpl::GetInstance()->GetDriverManager()->GetDebugDriver()->ReadFromSendBuffer(outBuffer.GetPointerUnsafe(), size);
#else
    return ResultUnsupportedDriverType();
#endif
}

nn::Result DebugServiceObject::OpenDriver(nn::htclow::detail::DriverType driverType) NN_NOEXCEPT
{
    return HtclowImpl::GetInstance()->OpenDriver(driverType);
}

nn::Result DebugServiceObject::CloseDriver() NN_NOEXCEPT
{
    HtclowImpl::GetInstance()->CloseDriver();
    NN_RESULT_SUCCESS;
}

nn::Result DebugServiceObject::GetDefaultAllocatorUsage(nn::sf::Out<std::uint64_t> outSize) NN_NOEXCEPT
{
    size_t size = HtclowImpl::GetInstance()->GetDefaultAllocatorUsage();

    *outSize = static_cast<uint64_t>(size);
    NN_RESULT_SUCCESS;
}

nn::Result DebugServiceObject::PrintDefaultAllocatorUsage() NN_NOEXCEPT
{
    HtclowImpl::GetInstance()->PrintDefaultAllocatorUsage();
    NN_RESULT_SUCCESS;
}

}}}
