﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace htclow { namespace server {

void InitializeAllocator() NN_NOEXCEPT;

void* AllocateDefault(size_t size) NN_NOEXCEPT;
void* AllocateThreadStack(size_t size) NN_NOEXCEPT;

void FreeDefault(void* p) NN_NOEXCEPT;
void FreeThreadStack(void* p) NN_NOEXCEPT;

size_t GetDefaultAllocatorUsage() NN_NOEXCEPT;
void PrintDefaultAllocatorUsage() NN_NOEXCEPT;

}}}
