﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/os/os_SdkConditionVariable.h>
#include <nn/os/os_SdkMutex.h>

#include "htclow_IDriver.h"

namespace nn { namespace htclow { namespace server { namespace driver {

class DebugDriver : public IDriver
{
public:
    DebugDriver() NN_NOEXCEPT
        : m_ReceiveBufferUpdateEvent(nn::os::EventClearMode_ManualClear)
        , m_SendBufferUpdateEvent(nn::os::EventClearMode_ManualClear)
        , m_CancelEvent(nn::os::EventClearMode_ManualClear)
    {
    }

    virtual Result Open() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Close() NN_NOEXCEPT NN_OVERRIDE;

    virtual Result Connect() NN_NOEXCEPT NN_OVERRIDE;
    virtual void Shutdown() NN_NOEXCEPT NN_OVERRIDE;

    virtual Result Send(const void* pBuffer, int bufferSize) NN_NOEXCEPT NN_OVERRIDE;
    virtual Result Receive(void* pOutBuffer, int bufferSize) NN_NOEXCEPT NN_OVERRIDE;

    virtual void Cancel() NN_NOEXCEPT NN_OVERRIDE;

    Result ReadFromSendBuffer(void* pOutBuffer, int readSize) NN_NOEXCEPT;
    Result WriteToReceiveBuffer(const void* pBuffer, int writeSize) NN_NOEXCEPT;

private:
    static const int BufferSize = 64 * 1024 * 1024;

    uint8_t* m_pReceiveBuffer;
    uint8_t* m_pSendBuffer;

    int m_ReceiveBufferHead;
    int m_ReceiveBufferTail;

    int m_SendBufferHead;
    int m_SendBufferTail;

    nn::os::SdkMutex m_ReceiveBufferMutex;
    nn::os::SdkMutex m_SendBufferMutex;

    nn::os::Event m_ReceiveBufferUpdateEvent;
    nn::os::Event m_SendBufferUpdateEvent;
    nn::os::Event m_CancelEvent;
};

}}}}
