﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "htcfs_Header.h"

namespace nn { namespace htcfs { namespace server {

class HeaderFactory
{
public:
    HeaderFactory() NN_NOEXCEPT
        : m_Version(0)
    {
    }

    void MakeRequestHeader(Header* pOutHeader, PacketType packetType) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2, int64_t param3) NN_NOEXCEPT;
    void MakeRequestHeader(Header* pOutHeader, PacketType packetType, int64_t bodySize, int64_t param0, int64_t param1, int64_t param2, int64_t param3, int64_t param4) NN_NOEXCEPT;

    int16_t GetVersion() NN_NOEXCEPT
    {
        return m_Version;
    }

    void SetVersion(int16_t version) NN_NOEXCEPT
    {
        m_Version = version;
    }

private:
    int16_t m_Version;
};

}}}
