﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.detail
{
    [ExternalStruct(4, 4)]
    [CppRefPath("<nn/nn_DeviceCode.h>")]
    public struct DeviceCodeType
    {
    }
}

namespace nn.gpio
{
    [ExternalStruct(16, 8)]
    [CppRefPath("<nn/gpio/gpio_Type.h>")]
    public struct WakeBitFlag
    {
    }
}


namespace nn.gpio
{
    // 実操作を担当する GPIO のセッションオブジェクト。
    // セッションの取得は GpioManager で行う。
    [CppRefPath("<nn/gpio/gpio_IPadSession.sfdl.h>")]
    interface IPadSession : IServiceObject
    {
        // GPIO インターフェースのうち SystemEvent を使うもの以外を記述
        [MethodId(0)]
        Result SetDirection(int32_t direction);

        [MethodId(1)]
        Result GetDirection(Out<int32_t> direction);

        [MethodId(2)]
        Result SetInterruptMode(int32_t mode);

        [MethodId(3)]
        Result GetInterruptMode(Out<int32_t> mode);

        [MethodId(4)]
        Result SetInterruptEnable(bool enable);

        [MethodId(5)]
        Result GetInterruptEnable(Out<bool> enable);

        [MethodId(6)]
        Result GetInterruptStatus(Out<int32_t> status);

        [MethodId(7)]
        Result ClearInterruptStatus();

        [MethodId(8)]
        Result SetValue(int32_t value);

        [MethodId(9)]
        Result GetValue(Out<int32_t> outValue);

        [MethodId(10)]
        Result BindInterrupt(Out<NativeHandle> handle);

        [MethodId(11)]
        Result UnbindInterrupt();

        [MethodId(12)]
        Result SetDebounceEnabled(bool isEnable);

        [MethodId(13)]
        Result GetDebounceEnabled(Out<bool> isEnable);

        [MethodId(14)]
        Result SetDebounceTime(int_t msecTime);

        [MethodId(15)]
        Result GetDebounceTime(Out<int_t> msecTime);

        [MethodId(16)]
        Result SetValueForSleepState(int32_t value);
    }

    // Pad ごとの GPIO セッションを返すマネージャークラス
    [CppRefPath("<nn/gpio/gpio_IManager.sfdl.h>")]
    interface IManager : IServiceObject
    {
        // [Gen1] TODO: Deprecate
        [MethodId(0)]
        Result OpenSessionForDev(Out<IPadSession> outSession, int32_t pad);

        // [Gen1] TODO: Deprecate
        [MethodId(1)]
        Result OpenSession(Out<IPadSession> outSession, int32_t pad);

        // [Gen1] TODO: Deprecate
        [MethodId(2)]
        Result OpenSessionForTest(Out<IPadSession> outSession, int32_t pad);

        // [Gen1] TODO: Deprecate
        [MethodId(3)]
        Result IsWakeEventActive(Out<bool> isActive, int32_t name);

        // [Gen2] NOT SUPPORTED
        // [Gen1] TODO: Deprecate
        [MethodId(4)]
        Result GetWakeEventActiveFlagSet(nn.sf.Out<WakeBitFlag> flag);

        // [Gen1] TODO: Deprecate
        [MethodId(5)]
        Result SetWakeEventActiveFlagSetForDebug(int32_t name, bool isEnabled);

        [MethodId(6)]
        Result SetWakePinDebugMode(int mode);

        // [Gen2]
        [MethodId(7)]
        Result OpenSession2(Out<IPadSession> outSession, nn.detail.DeviceCodeType padName);

        // [Gen2]
        [MethodId(8)]
        Result IsWakeEventActive2(Out<bool> isActive, nn.detail.DeviceCodeType name);

        // [Gen2]
        [MethodId(9)]
        Result SetWakeEventActiveFlagSetForDebug2(nn.detail.DeviceCodeType name, bool isEnabled);
    }
}
