﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <mutex>

#include <nn/nn_Common.h>
#include <nn/os/os_InterruptEvent.h>
#include <nn/os/os_Mutex.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/gpio/driver/gpio_PadAccessor.h>

namespace nn {
namespace gpio {
namespace driver {
namespace detail {


class PadEventHolder
{
public:
    explicit PadEventHolder(int padNumber) NN_NOEXCEPT :
        m_IsInternalInterruptEnable(false),
        m_PadNumber(padNumber),
        m_pEvent(nullptr),
        m_EventHolderMutex(false)
        {}

    bool IsBoundEvent() NN_NOEXCEPT;
    void DestroyEvent() NN_NOEXCEPT;
    void AttachEvent(nn::os::SystemEventType* pEvent) NN_NOEXCEPT;
    void DetachEvent() NN_NOEXCEPT;
    void SetInternalInterruptFlag(bool isEnable) NN_NOEXCEPT;
    bool IsInternalInterruptEnable() const NN_NOEXCEPT;
    nn::os::SystemEventType* GetSystemEvent() NN_NOEXCEPT;
    int GetPadNumber() NN_NOEXCEPT;

public:
    util::IntrusiveListNode    m_Node;

private:

    bool                       m_IsInternalInterruptEnable;
    int                        m_PadNumber;
    nn::os::SystemEventType*   m_pEvent;
    nn::os::Mutex              m_EventHolderMutex;
};

} // detail
} // driver
} // gpio
} // nn
