﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Result.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/fs/fs_SaveDataTransfer.h>
#include <nn/fs/fs_Utility.h>
#include <nn/fs/detail/fs_ResultHandlingUtility.h>
#include <nn/fssrv/sf/fssrv_ISaveDataTransfer.h>

#include <nn/fssrv/sf/fssrv_IFileSystemProxy.h>

namespace nn { namespace fs {

    Result SaveDataTransferManager::OpenSaveDataImporter(std::unique_ptr<SaveDataImporter>* outValue, int64_t* outRequiredSize, const void* exportIntialData, size_t exportInitialDataSize, const account::Uid& user, SaveDataSpaceId saveDataSpaceId) NN_NOEXCEPT
    {
        return OpenSaveDataImporter(outValue, outRequiredSize, exportIntialData, exportInitialDataSize, ConvertAccountUidToFsUserId(user), saveDataSpaceId);
    }

}}

