﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_SnsAccountFriend.h>
#include <nn/friends/detail/friends_ImplSnsAccountFriend.h>
#include <nn/friends/detail/friends_ApiDetail.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/nn_SdkAssert.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(SnsAccountFriend)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(SnsAccountFriend)

namespace nn { namespace friends {

SnsAccountFriend::SnsAccountFriend() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId SnsAccountFriend::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

SnsAccountType SnsAccountFriend::GetType() const NN_NOEXCEPT
{
    return static_cast<SnsAccountType>(CONST_GET_IMPL()->type);
}

const SnsAccountProfile& SnsAccountFriend::GetSnsAccountProfile() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->profile;
}

bool SnsAccountFriend::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
