﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/friends_FriendCandidate.h>
#include <nn/friends/detail/friends_ImplFriendCandidate.h>

#define GET_IMPL() NN_DETAIL_FRIENDS_GET_IMPL(FriendCandidate)
#define CONST_GET_IMPL() NN_DETAIL_FRIENDS_CONST_GET_IMPL(FriendCandidate)

namespace nn { namespace friends {

FriendCandidate::FriendCandidate() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_CLEAR_IMPL();
}

nn::account::NetworkServiceAccountId FriendCandidate::GetAccountId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->accountId;
}

FriendCandidateType FriendCandidate::GetType() const NN_NOEXCEPT
{
    return static_cast<FriendCandidateType>(CONST_GET_IMPL()->type);
}

const ExternalApplicationCatalogId& FriendCandidate::GetExternalApplicationCatalogId() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->catalogId;
}

const PlayRecord& FriendCandidate::GetPlayRecord() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->playRecord;
}

bool FriendCandidate::IsValid() const NN_NOEXCEPT
{
    return CONST_GET_IMPL()->isValid;
}

}}
