﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/friends_NotificationService.generic.h>
#include <nn/friends/friends_Result.h>

namespace nn { namespace friends { namespace detail { namespace service {

NotificationServiceForGeneric::NotificationServiceForGeneric(const nn::account::Uid& uid) NN_NOEXCEPT :
    m_Uid(uid),
    m_IsEventCreated(false)
{
    NN_UNUSED(m_Uid);
}

NotificationServiceForGeneric::~NotificationServiceForGeneric() NN_NOEXCEPT
{
}

nn::Result NotificationServiceForGeneric::GetEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle) NN_NOEXCEPT
{
    if (!m_IsEventCreated)
    {
        NN_ABORT_UNLESS_RESULT_SUCCESS(nn::os::CreateSystemEvent(m_Event.GetBase(),
            nn::os::EventClearMode_ManualClear, true));

        m_IsEventCreated = true;
    }

    outHandle.Set(nn::sf::NativeHandle(m_Event.DetachReadableHandle(), false));

    NN_RESULT_SUCCESS;
}

nn::Result NotificationServiceForGeneric::Clear() NN_NOEXCEPT
{
    NN_RESULT_SUCCESS;
}

nn::Result NotificationServiceForGeneric::Pop(nn::sf::Out<nn::friends::detail::ipc::SizedNotificationInfo> outInfo) NN_NOEXCEPT
{
    NN_UNUSED(outInfo);

    NN_RESULT_THROW(ResultNotificationNotFound());
}

}}}}
