﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskReadFriendRequest.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

ReadFriendRequestTask::ReadFriendRequestTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result ReadFriendRequestTask::SetParameter(RequestId requestId) NN_NOEXCEPT
{
    m_RequestId = requestId;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result ReadFriendRequestTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepRead());
    NN_RESULT_DO(StepGetReceivedFriendRequestCount());

    NN_RESULT_SUCCESS;
}

nn::Result ReadFriendRequestTask::StepRead() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] ReadFriendRequestTask::StepRead ...\n");

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/friend_requests/%016llx", WebApi::GetFqdn(), m_RequestId.value);

    char patch[128] = {};
    NN_RESULT_DO(CreateReadPatch(patch, sizeof (patch)));

    NN_RESULT_DO(stream.Open("PATCH", url));
    NN_RESULT_DO(stream.AddRequestHeader("Content-Type: application/json-patch+json"));
    NN_RESULT_DO(stream.SetPostField(patch, false));

    detail::service::json::JsonEventHandler handler;

    NN_RESULT_DO(WebApi::Call(handler, stream, GetUid(), GetCancelable()));

    NN_RESULT_SUCCESS;
}

nn::Result ReadFriendRequestTask::CreateReadPatch(char* buffer, size_t size) NN_NOEXCEPT
{
    detail::service::json::FixedSizeAllocator allocator;
    detail::service::json::JsonMemoryOutputStream stream;

    stream.Open(buffer, size);
    stream.PutBegin();

    detail::service::json::JsonWriter writer(stream, &allocator, 16);

    detail::service::json::JsonPatchGenerator::BeginWrite(writer);
    {
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/receiver/read");
        {
            writer.Bool(true);
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
    }
    detail::service::json::JsonPatchGenerator::EndWrite(writer);

    stream.PutEnd();
    stream.Close();

    NN_RESULT_SUCCESS;
}

}}}}}
