﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/task/friends_TaskChangeFriendOnlineNotificationFlag.h>
#include <nn/friends/detail/service/core/handler/friends_HandlerFriendResource.h>
#include <nn/friends/detail/service/core/friends_FriendListManager.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

ChangeFriendOnlineNotificationFlagTask::ChangeFriendOnlineNotificationFlagTask() NN_NOEXCEPT :
    m_IsParameterSet(false)
{
}

nn::Result ChangeFriendOnlineNotificationFlagTask::SetParameter(nn::account::NetworkServiceAccountId accountId, bool newValue) NN_NOEXCEPT
{
    m_FriendAccountId = accountId;
    m_NewValue = newValue;

    m_IsParameterSet = true;

    NN_RESULT_SUCCESS;
}

nn::Result ChangeFriendOnlineNotificationFlagTask::Main() NN_NOEXCEPT
{
    NN_SDK_ASSERT(m_IsParameterSet);

    NN_RESULT_DO(Account::EnsureNetworkServiceAccessToken(GetUid(), GetCancelable()));

    NN_RESULT_DO(StepChange());

    NN_RESULT_SUCCESS;
}

nn::Result ChangeFriendOnlineNotificationFlagTask::StepChange() NN_NOEXCEPT
{
    NN_DETAIL_FRIENDS_INFO("[friends] ChangeFriendOnlineNotificationFlagTask::StepChange ...\n");

    nn::account::NetworkServiceAccountId accountId = {};
    NN_RESULT_DO(Account::GetNetworkServiceAccountId(&accountId, GetUid()));

    detail::service::json::JsonHttpInputStream stream;

    char url[160] = {};
    nn::util::SNPrintf(url, sizeof (url),
        "https://%s/2.0.0/users/%016llx/friends/%016llx", WebApi::GetFqdn(), accountId.id, m_FriendAccountId.id);

    char patch[128] = {};
    NN_RESULT_DO(CreateChangePatch(patch, sizeof (patch)));

    NN_RESULT_DO(stream.Open("PATCH", url));
    NN_RESULT_DO(stream.AddRequestHeader("Content-Type: application/json-patch+json"));
    NN_RESULT_DO(stream.SetPostField(patch, false));

    FriendResourceHandler handler;

    NN_RESULT_TRY(WebApi::Call(handler, stream, GetUid(), GetCancelable()))
        NN_RESULT_CATCH(ResultServerError404ResourceIsNotFound)
        {
            NN_RESULT_THROW(ResultNotFriend());
        }
    NN_RESULT_END_TRY;

    NN_RESULT_DO(FriendListManager::GetInstance().UpdateFriend(GetUid(), handler.GetResource(), false));

    NN_RESULT_SUCCESS;
}

nn::Result ChangeFriendOnlineNotificationFlagTask::CreateChangePatch(char* buffer, size_t size) NN_NOEXCEPT
{
    detail::service::json::FixedSizeAllocator allocator;
    detail::service::json::JsonMemoryOutputStream stream;

    stream.Open(buffer, size);
    stream.PutBegin();

    detail::service::json::JsonWriter writer(stream, &allocator, 16);

    detail::service::json::JsonPatchGenerator::BeginWrite(writer);
    {
        detail::service::json::JsonPatchGenerator::BeginWriteAddOperation(writer, "/extras/self/isOnlineNotification");
        {
            writer.Bool(m_NewValue);
        }
        detail::service::json::JsonPatchGenerator::EndWriteAddOperation(writer);
    }
    detail::service::json::JsonPatchGenerator::EndWrite(writer);

    stream.PutEnd();
    stream.Close();

    NN_RESULT_SUCCESS;
}

}}}}}
