﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerSnsAccountProfile.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

SnsAccountProfileHandler::SnsAccountProfileHandler() NN_NOEXCEPT :
    m_OutProfile(nullptr),
    m_Bits()
{
}

void SnsAccountProfileHandler::Initialize(SnsAccountProfile* outProfile) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outProfile);

    m_OutProfile = outProfile;

    std::memset(m_OutProfile, 0, sizeof (SnsAccountProfile));
}

bool SnsAccountProfileHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(isOverflowed);

    if (!m_Bits.name1 &&
        jsonPath.Compare("$.name"))
    {
        m_Bits.name1 = true;

        if (length > 0)
        {
            // コードポイント数の上限は設けない。
            nn::util::CopyUtf8String(m_OutProfile->name1.value, sizeof (m_OutProfile->name1.value), value, length, INT_MAX);
        }
    }
    else if (!m_Bits.name2 &&
        jsonPath.Compare("$.screen_name"))
    {
        m_Bits.name2 = true;

        if (length > 0)
        {
            // コードポイント数の上限は設けない。
            nn::util::CopyUtf8String(m_OutProfile->name2.value, sizeof (m_OutProfile->name2.value), value, length, INT_MAX);
        }
    }
    else if (!m_Bits.imageUrl &&
        jsonPath.Compare("$.profile_image_url"))
    {
        m_Bits.imageUrl = true;

        // 正しくバッファに収まる場合のみコピーする。
        if (length < sizeof (m_OutProfile->imageUrl.value))
        {
            nn::util::Strlcpy(m_OutProfile->imageUrl.value, value, sizeof (m_OutProfile->imageUrl.value));
        }
    }

    return true;
}

}}}}}
