﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerSnsAccountLinkage.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

SnsAccountLinkageHandler::SnsAccountLinkageHandler() NN_NOEXCEPT :
    m_OutLinkage(nullptr),
    m_Bits()
{
}

void SnsAccountLinkageHandler::Initialize(SnsAccountLinkage* outLinkage) NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outLinkage);

    m_OutLinkage = outLinkage;

    std::memset(m_OutLinkage, 0, sizeof (SnsAccountLinkage));
}

bool SnsAccountLinkageHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(value);
    NN_UNUSED(length);
    NN_UNUSED(isOverflowed);

    if (!m_Bits.isFacebookLinked &&
        jsonPath.Compare("$.facebook.uid"))
    {
        m_Bits.isFacebookLinked = true;
        m_OutLinkage->isFacebookLinked = true;
    }
    else if (!m_Bits.isTwitterLinked &&
        jsonPath.Compare("$.twitter.uid"))
    {
        m_Bits.isTwitterLinked = true;
        m_OutLinkage->isTwitterLinked = true;
    }

    return true;
}

}}}}}
