﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerFriendRequestResourceCount.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

FriendRequestResourceCountHandler::FriendRequestResourceCountHandler() NN_NOEXCEPT :
    m_Count(0),
    m_ReadCount(0)
{
}

int FriendRequestResourceCountHandler::GetUnreadCount() const NN_NOEXCEPT
{
    return m_Count - m_ReadCount;
}

int FriendRequestResourceCountHandler::GetReadCount() const NN_NOEXCEPT
{
    return m_ReadCount;
}

bool FriendRequestResourceCountHandler::OnStartObject(const detail::service::json::JsonPath& jsonPath) NN_NOEXCEPT
{
    if (jsonPath.Match("$.items[*]"))
    {
        std::memset(&m_Bits, 0, sizeof (m_Bits));
    }

    return true;
}

bool FriendRequestResourceCountHandler::OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT
{
    NN_UNUSED(numObjects);

    if (jsonPath.Match("$.items[*]"))
    {
        m_Count++;
    }

    return true;
}

bool FriendRequestResourceCountHandler::OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT
{
    if (!m_Bits.read &&
        jsonPath.Match("$.items[*].extras.receiver.read"))
    {
        m_Bits.read = true;

        if (value)
        {
            m_ReadCount++;
        }
    }

    return true;
}

}}}}}
