﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/service/core/handler/friends_HandlerFriendRequestResource.h>

namespace nn { namespace friends { namespace detail { namespace service { namespace core {

FriendRequestResourceHandler::FriendRequestResourceHandler() NN_NOEXCEPT :
    m_ListType(RequestListType_Received),
    m_Resource(),
    m_Bits()
{
}

void FriendRequestResourceHandler::Initialize(RequestListType listType) NN_NOEXCEPT
{
    m_ListType = listType;

    if (m_ListType == RequestListType_Sent)
    {
        m_Resource.read = true;
    }
}

const FriendRequestResource& FriendRequestResourceHandler::GetResource() const NN_NOEXCEPT
{
    return m_Resource;
}

bool FriendRequestResourceHandler::OnEndObject(const detail::service::json::JsonPath& jsonPath, size_t numObjects) NN_NOEXCEPT
{
    NN_UNUSED(numObjects);

    if (jsonPath.Compare("$"))
    {
        if (m_Bits.requestId && m_Bits.accountId && m_Bits.nickname && m_Bits.profileImageUrl &&
            m_Bits.requestType && m_Bits.requestStatus)
        {
        }
        else
        {
            std::memset(&m_Resource, 0, sizeof (m_Resource));
        }
    }

    return true;
}

bool FriendRequestResourceHandler::OnBoolean(const detail::service::json::JsonPath& jsonPath, bool value) NN_NOEXCEPT
{
    if (m_ListType == RequestListType_Received)
    {
        if (!m_Bits.read &&
            jsonPath.Compare("$.extras.receiver.read"))
        {
            m_Resource.read = value;
            m_Bits.read = true;
        }
    }

    return true;
}

bool FriendRequestResourceHandler::OnInteger(const detail::service::json::JsonPath& jsonPath, const detail::service::json::AnyInteger& value) NN_NOEXCEPT
{
    if (!m_Bits.registeredTime &&
        jsonPath.Compare("$.createdAt"))
    {
        m_Resource.routeInfo.time.value = value.s;
        m_Bits.registeredTime = true;
    }

    return true;
}

bool FriendRequestResourceHandler::OnString(const detail::service::json::JsonPath& jsonPath, const char* value, size_t length, bool isOverflowed) NN_NOEXCEPT
{
    NN_UNUSED(isOverflowed);

    if (!m_Bits.requestId &&
        jsonPath.Compare("$.id"))
    {
        RequestId requestId;

        if (detail::util::HexToNumber(&requestId.value, value))
        {
            m_Resource.requestId = requestId;
            m_Bits.requestId = true;
        }
    }
    else if (!m_Bits.requestType &&
        jsonPath.Compare("$.channels[0]")) // 最初に出現したチャンネルだけで十分。
    {
        m_Resource.requestType = ParameterConverter::ConvertRequestType(value);
        m_Bits.requestType = true;
    }
    else if (!m_Bits.requestStatus &&
        jsonPath.Compare("$.state"))
    {
        m_Resource.requestStatus = ParameterConverter::ConvertRequestStatus(value);
        m_Bits.requestStatus = true;
    }
    else if (!m_Bits.appId &&
        jsonPath.Compare("$.extras.senderAndReceiver.route:appInfo:appId"))
    {
        nn::ApplicationId appId;

        if (detail::util::HexToNumber(&appId.value, value))
        {
            m_Resource.routeInfo.appInfo.appId = appId;
            m_Bits.appId = true;
        }
    }
    else if (!m_Bits.presenceGroupId &&
        jsonPath.Compare("$.extras.senderAndReceiver.route:appInfo:presenceGroupId"))
    {
        Bit64 presenceGroupId;

        if (detail::util::HexToNumber(&presenceGroupId, value))
        {
            m_Resource.routeInfo.appInfo.presenceGroupId = presenceGroupId;
            m_Bits.presenceGroupId = true;
        }
    }
    else if (!m_Bits.catalogId &&
        jsonPath.Compare("$.extras.senderAndReceiver.route:candidate:catalogId"))
    {
        if (ParameterConverter::ConvertExternalApplicationCatalogId(&m_Resource.routeInfoExtra.candidate.catalogId, value))
        {
            m_Bits.catalogId = true;
        }
    }
    // receiver の情報を集める。
    else if (m_ListType == RequestListType_Sent)
    {
        if (!m_Bits.accountId &&
            jsonPath.Compare("$.receiverId"))
        {
            nn::account::NetworkServiceAccountId accountId;

            if (detail::util::HexToNumber(&accountId.id, value))
            {
                m_Resource.accountId = accountId;
                m_Bits.accountId = true;
            }
        }
        else if (!m_Bits.nickname &&
            jsonPath.Compare("$.receiver.nickname"))
        {
            nn::util::Strlcpy(m_Resource.nickname.name, value, sizeof (m_Resource.nickname.name));
            m_Bits.nickname = true;
        }
        else if (!m_Bits.profileImageUrl &&
            jsonPath.Compare("$.receiver.thumbnailUrl"))
        {
            nn::util::Strlcpy(m_Resource.profileImageUrl.value, value,
                sizeof (m_Resource.profileImageUrl.value));
            m_Bits.profileImageUrl = true;
        }
        else if (!m_Bits.miiName &&
            jsonPath.Compare("$.extras.sender.route:nnid:miiName"))
        {
            nn::util::CopyUtf8String(m_Resource.routeInfoExtra.nnid.miiName.value,
                sizeof (m_Resource.routeInfoExtra.nnid.miiName.value), value, length, MiiNameLengthMax);
            m_Bits.miiName = true;
        }
        else if (!m_Bits.miiImageUrlParam &&
            jsonPath.Compare("$.extras.sender.route:nnid:miiImageUrlParam"))
        {
            nn::util::Strlcpy(m_Resource.routeInfoExtra.nnid.miiImageUrlParam.value, value,
                sizeof (m_Resource.routeInfoExtra.nnid.miiImageUrlParam.value));
            m_Bits.miiImageUrlParam = true;
        }
        else if (!m_Bits.inAppScreenName &&
            jsonPath.Compare("$.extras.sender.route:name"))
        {
            nn::util::CopyUtf8String(m_Resource.routeInfo.name.name,
                sizeof (m_Resource.routeInfo.name.name), value, length, InAppScreenNameLengthMax);
            m_Bits.inAppScreenName = true;
        }
        else if (!m_Bits.language &&
            jsonPath.Compare("$.extras.sender.route:name:language"))
        {
            nn::util::Strlcpy(m_Resource.routeInfo.name.language.string, value,
                sizeof (m_Resource.routeInfo.name.language.string));
            m_Bits.language = true;
        }
    }
    // sender の情報を集める。
    else if (m_ListType == RequestListType_Received)
    {
        if (!m_Bits.accountId &&
            jsonPath.Compare("$.senderId"))
        {
            nn::account::NetworkServiceAccountId accountId;

            if (detail::util::HexToNumber(&accountId.id, value))
            {
                m_Resource.accountId = accountId;
                m_Bits.accountId = true;
            }
        }
        else if (!m_Bits.nickname &&
            jsonPath.Compare("$.sender.nickname"))
        {
            nn::util::Strlcpy(m_Resource.nickname.name, value, sizeof (m_Resource.nickname.name));
            m_Bits.nickname = true;
        }
        else if (!m_Bits.profileImageUrl &&
            jsonPath.Compare("$.sender.thumbnailUrl"))
        {
            nn::util::Strlcpy(m_Resource.profileImageUrl.value, value,
                sizeof (m_Resource.profileImageUrl.value));
            m_Bits.profileImageUrl = true;
        }
        else if (!m_Bits.miiName &&
            jsonPath.Compare("$.extras.senderAndReceiver.route:nnid:miiName"))
        {
            nn::util::CopyUtf8String(m_Resource.routeInfoExtra.nnid.miiName.value,
                sizeof (m_Resource.routeInfoExtra.nnid.miiName.value), value, length, MiiNameLengthMax);
            m_Bits.miiName = true;
        }
        else if (!m_Bits.miiImageUrlParam &&
            jsonPath.Compare("$.extras.senderAndReceiver.route:nnid:miiImageUrlParam"))
        {
            nn::util::Strlcpy(m_Resource.routeInfoExtra.nnid.miiImageUrlParam.value, value,
                sizeof (m_Resource.routeInfoExtra.nnid.miiImageUrlParam.value));
            m_Bits.miiImageUrlParam = true;
        }
        else if (!m_Bits.inAppScreenName &&
            jsonPath.Compare("$.extras.senderAndReceiver.route:name"))
        {
            nn::util::CopyUtf8String(m_Resource.routeInfo.name.name,
                sizeof (m_Resource.routeInfo.name.name), value, length, InAppScreenNameLengthMax);
            m_Bits.inAppScreenName = true;
        }
        else if (!m_Bits.language &&
            jsonPath.Compare("$.extras.senderAndReceiver.route:name:language"))
        {
            nn::util::Strlcpy(m_Resource.routeInfo.name.language.string, value,
                sizeof (m_Resource.routeInfo.name.language.string));
            m_Bits.language = true;
        }
    }

    return true;
} // NOLINT(impl/function_size)

}}}}}
