﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/friends/detail/friends_ShimLibraryGlobal.h>
#include <mutex>

namespace nn { namespace friends { namespace detail {

ShimLibraryGlobal::ShimLibraryGlobal() NN_NOEXCEPT :
    m_Session(nullptr)
{
}

void ShimLibraryGlobal::Initialize() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (!m_Session)
    {
        CreateIpcSession();
    }
}

detail::ipc::IFriendService* ShimLibraryGlobal::GetSyncSession() NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (!m_Session)
    {
        CreateIpcSession();
    }

    return m_Session;
}

nn::Result ShimLibraryGlobal::CreateAsyncSession(detail::ipc::IFriendService** outSession) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (!m_Session)
    {
        CreateIpcSession();
    }

    NN_RESULT_DO(detail::ipc::CreateFriendService(outSession));

    NN_RESULT_SUCCESS;
}

nn::Result ShimLibraryGlobal::CreateNotificationService(detail::ipc::INotificationService** outService, const nn::account::Uid& uid) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (!m_Session)
    {
        CreateIpcSession();
    }

    NN_RESULT_DO(detail::ipc::CreateNotificationService(outService, uid));

    NN_RESULT_SUCCESS;
}

nn::Result ShimLibraryGlobal::CreateDaemonSuspendSessionService(detail::ipc::IDaemonSuspendSessionService** outService) NN_NOEXCEPT
{
    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    if (!m_Session)
    {
        CreateIpcSession();
    }

    NN_RESULT_DO(detail::ipc::CreateDaemonSuspendSessionService(outService));

    NN_RESULT_SUCCESS;
}

void ShimLibraryGlobal::CreateIpcSession() NN_NOEXCEPT
{
    detail::ipc::Initialize();
    NN_ABORT_UNLESS_RESULT_SUCCESS(detail::ipc::CreateFriendService(&m_Session));
}

}}}
